CREATE OR REPLACE FUNCTION TSystem.views__ReportingLieferschein__recreate() RETURNS VOID AS $$
BEGIN

    DROP VIEW IF EXISTS treporting.lieferschein_pos_beleg_positionen;
    CREATE OR REPLACE VIEW treporting.lieferschein_pos_beleg_positionen AS
     SELECT
      'lieferschein_pos'::VARCHAR(30)                               AS position_tablename,
      lieferschein_pos.dbrid                                        AS position_dbrid,
      belp_id                                                       AS position_id,
      belp_id                                                       AS position_abzu_join_id,
      NULL::CHAR(1)                                                 AS position_status,
      NULL::CHAR(1)                                                 AS position_identnummer, 
      belp_pos                                                      AS position_identpos,
      
      belp_erstelldatum                                             AS datum_erfasst,
      
      NULL::CHAR(1)                                                 AS referenz_identdatum,
      COALESCE(ag_hwpos, belp_pos::VARCHAR(5))                      AS position_coalesce_handwerker_posnr,

      ag_astat                                                      AS position_status1,
      ag_nr                                                         AS position_identnummer1,
      ag_pos                                                        AS position_identpos1,
      NULL::DATE                                                    AS referenz_identdatum1,

      belp_dokument_id                                              AS position_dokument_id,
      ag_rahmen_ag_id IS NOT NULL                                   AS position_israhmenabruf, --war false #6410
      ag_rahmen_ag_id                                               AS position_rahmen_nr_referenz, --NULL::CHAR(1) #6410
      NULL::INTEGER                                                 AS position_rahmen_abrufnr,

      
      belp_referenz                                                 AS referenz,
      ag_bdapos                                                     AS referenz_pos,
      ag_bdat                                                       AS referenz_vondatum,
      tartikel.me__menge_uf1__in__menge(belp_mce, ag_stk_uf1)                            AS referenz_menge,                              --Menge Bestellt (Verkauf an Kunde)
      tartikel.me__menge_uf1__in__menge(belp_mce, IFTHEN(ag_done, ag_stk_uf1, ag_stkl))  AS referenz_menge_erledigt,                     --Menge bereits geliefert ;; wenn erledigt, dann wird Geliefert=Bestellt gesetzt, um Restmenge auszublenden
      
      ag_dispokrzl                                                  AS adresse_ansprechpartner_adressant_kurzzeichen,
      ag_dispo                                                      AS adresse_ansprechpartner_adressant,
      NULL::CHAR(1)                                                 AS adresse_ansprechpartner_intern_ident,
      NULL::CHAR(1)                                                 AS adresse_ansprechpartner_intern_name,
     
      beld_krzlieferung                                             AS adresse_adressant, 
      NULL::CHAR(1)                                                 AS adresse_lieferadresse,
      belp_krzrechnung                                              AS adresse_rechnungsadresse,
     
      belp_aknr                                                     AS artikelnummer,
      ag_aknr_idx                                                   AS artikelnummer_index,
      COALESCE(CASE WHEN (beld_belegart=6) THEN e_best ELSE NULL END,
               ag_aknr_referenz, az_kunr)                           AS artikelnummer_adressant, --für Beistellung die Lieferanten-Artnr               
      
      COALESCE(CASE WHEN (beld_belegart=6) THEN e_best ELSE NULL END,
               ag_aknr_referenz,az_kunr, belp_aknr)                 AS artikelnummer_coalesce_adressant_intern,
      COALESCE(belp_akbez, lang_artbez(belp_aknr, ReportLang_current()), ak_bez)
                                                                    AS artikelbezeichnung, 
      COALESCE(belp_akbez, az_bez, lang_artbez(belp_aknr, ReportLang_current()), ak_bez)
                                                                    AS artikelbezeichnung_coalesce_adressant_intern,  
      ak_znr                                                        AS artikel_zeichnungsnummer,
      COALESCE(lang_artdim(belp_aknr, ReportLang_current()), ak_dim)
                                                                    AS artikel_dimension, 
      COALESCE(lang_artmat(belp_aknr, ReportLang_current()), ak_mat)
                                                                    AS artikel_materialnummer,
      ak_din                                                        AS artikel_materialnorm,
      belp_gewicht                                                  AS artikel_pos_gewicht,
      NULL::INTEGER                                                 AS artikel_kost_rust,
      NULL::INTEGER                                                 AS artikel_kost_fert,
      NULL::INTEGER                                                 AS artikel_kost_mat,
      NULL::INTEGER                                                 AS artikel_kost_aw,
      ak_warencode                                                  AS artikel_warencode,
      ak_fertigung                                                  AS artikel_fert,
      (SELECT lang_land( ak_l_iso, ReportLang_current() ))          AS artikel_ursprung,
      
      belp_erledigt                                                 AS done,
      belp_storniert                                                AS storno,
      False                                                         AS optional,
                    
      NULL::FLOAT/*belp_kurs*/                                      AS kurs_waer,
      NULL::FLOAT/*belp_preis*/                                     AS preis_me_netto,
      NULL::FLOAT                                                   AS preiseinheit, -- 6447, 6772
      NULL::FLOAT/*belp_preis_gme*/                                 AS preis_me_netto_uf1,
      NULL::FLOAT/*belp_preis_gme_basis_w*/                         AS preis_me_netto_basis_w,
      NULL::FLOAT                                                   AS preis_me_netto_basis_w_uf1, 
      NULL::FLOAT                                                   AS preis_mengeneinheit_artmgc_id, -- 7678
      NULL::CHAR(1)                                                 AS preis_mengeneinheit_bez_iso, -- 7678
      NULL::FLOAT/*belp_netto*/                                     AS preis_inkl_rabatt_abzu,
      NULL::FLOAT/*belp_brutto*/                                    AS preis_inkl_rabatt_abzu_steuer,
      NULL::FLOAT                                                   AS preis_me_inkl_posrabatt_ohne_abzu,
      NULL::FLOAT                                                   AS preis_me_inkl_rabatt_ohne_abzu,
      NULL::FLOAT                                                   AS preis_positionswert_nur_hauptpos_werthaltig,
      NULL::FLOAT/*belp_sumabzu?Brutto?*/                           AS preis_pos_abzusum,

      false                                                         AS poshatvkp,
      
      NULL::FLOAT/*belp_steuproz*/                                  AS steuproz,
      
      belp_menge                                                    AS menge,
      NULL::FLOAT                                                   AS menge_1in_preiseinheit,  -- 7678 Umrechnungsfaktor: 1 Einheit der Menge entspricht 1 Einheit der Menge des Preises
      NULL::FLOAT                                                   AS menge_rahmen_abrlos,
      belp_menge_gme                                                AS menge_uf1,
      belp_menge_done_gme                                           AS menge_geliefert_uf1,
      NULL::FLOAT                                                   AS menge_verrechnet,
      --belp_menge-belp_menge_done                                  AS menge_offen_mengeneinheit,
      belp_menge_done_gme-belp_menge_gme                            AS menge_offen_uf1,                             --Menge offen, noch zu verrechnen
      NULL::FLOAT/*belp_rabatt*/                                    AS rabatt,
      NULL::FLOAT                                                   AS rabatt_hint,
      NULL::FLOAT                                                   AS rabatt_ges,
      belp_mce                                                      AS mengeneinheit_artmgc_id,
      lang_artmgc_id_iso(belp_mce, ReportLang_current())            AS mengeneinheit_bez_iso,
      
      COALESCE(IFTHEN(Trim(belp_dokutxt_rtf)='', NULL::TEXT, belp_dokutxt_rtf), belp_dokutxt)::TEXT AS postxt_rtf,
      
      belp_projektnummer                                            AS an_nr,
      (SELECT an_bez FROM anl WHERE an_nr=belp_projektnummer)       AS an_bez,
      
      NULL::DATE/*belp_termin*/                                     AS datum_geplant,
      NULL::DATE/*belp_termin_bestaetigt*/                          AS datum_bestaetigt,
      NULL::DATE                                                    AS datum_coalesce_bestaetigt_geplant,
      NULL::CHAR(1)                                                 AS datum_text,
      NULL::DATE                                                    AS datum_woche_geplant,
      NULL::DATE                                                    AS datum_woche_bestaetigt,
      NULL::CHAR(1)                                                 AS datum_woche,
      NULL::DATE                                                    AS datum_auslieferung
     
    FROM
      lieferschein_pos JOIN art ON ak_nr=belp_aknr
                       LEFT JOIN auftg ON ag_id=belp_ag_id
                       LEFT JOIN artzuo ON az_id=(SELECT az_id FROM artzuo WHERE az_prokrz=belp_krzbesteller AND az_pronr=belp_aknr ORDER BY az_gdatum DESC LIMIT 1)
                       LEFT JOIN lieferschein ON belp_dokument_id = beld_id AND beld_belegtyp = 'LFS' --Um Lieferadresse aus Kopf zu holen
                       LEFT JOIN epreis ON e_aknr = belp_aknr AND e_lkn = beld_krzlieferung AND e_gdatum = (SELECT MAX(e_gdatum) FROM epreis WHERE e_aknr = belp_aknr AND e_lkn = beld_krzlieferung)
    ORDER BY
      ag_astat, ag_nr, ag_pos, belp_pos;
      

    DROP VIEW IF EXISTS treporting.lieferschein_beleg_kopfdaten;
    CREATE OR REPLACE VIEW treporting.lieferschein_beleg_kopfdaten AS
     SELECT
       beld_dokunr                                                  AS dokument_id,
       beld_id                                                      AS dokument_join_id,
       beld_dokunr                                                  AS dokument_dms_id,  --war nur anf_nr
       beld_dokunr                                                  AS dokument_nummer,
       NULL::NUMERIC                                                AS dokument_anzahlprozent,
       NULL::VARCHAR(10)                                            AS dokument_status,
       false                                                        AS dokument_multidok,
       true                                                         AS definitiv,                                                                   
       CASE WHEN (beld_belegart=4) THEN 'lfslds_rk'
        WHEN (beld_belegart=6)     THEN 'lfslds_be'
        WHEN (beld_belegart=10)    THEN 'lfs_storno'
        ELSE 'lfs' END                                              AS doktype_force,  -- #9896 Einkaufslieferscheine     
       beld_erstelldatum                                            AS dokument_erstelldatum,
       'trans.kopf.ihrebestellung'::VARCHAR(75)                     AS dokument_reftitkunde,
       NULL::VARCHAR(75)                                            AS dokument_reftiteigen,
       'trans.kopf.unserauftrag'::VARCHAR(75)                       AS dokument_reftiteigen1,
       
       COALESCE(beld_titel, 
        CASE WHEN (beld_belegart=4)  THEN 'trans.kopf.retourenlieferschein'
             WHEN (beld_belegart=6)  THEN 'trans.kopf.beistelllieferschein'
             WHEN (beld_belegart=10) THEN 'trans.kopf.stornolieferschein'
             ELSE 'trans.kopf.lieferschein' END )                   AS dokument_titel, -- #9896 Einkaufslieferscheine

       (CASE WHEN (beld_belegart=4)  THEN 'trans.kopf.retourenlieferschein'
        WHEN (beld_belegart=6)       THEN 'trans.kopf.beistelllieferschein'
        WHEN (beld_belegart=10)      THEN 'trans.kopf.stornolieferschein'
        ELSE 'trans.kopf.lieferschein' END)::VARCHAR(75)            AS dokument_titel_doktype, -- #9896 Einkaufslieferscheine

       COALESCE(beld_kopftext_rtf, beld_kopftext)                   AS dokument_kopftext,
       COALESCE(beld_fusstext_rtf, beld_fusstext)                   AS dokument_fusstext,
       NULL::TEXT                                                   AS dokument_qhint,
       
       IFTHEN(a1_export, COALESCE(a1_export_adktxt_rtf,belarzu__zu_tit__gettxt('EXPORT-INT')), IFTHEN(a1_euexport,COALESCE(a1_export_adktxt_rtf, belarzu__zu_tit__gettxt('EXPORT-EU')), NULL))::TEXT
                                                                    AS dokument_exporttxt,
       IFTHEN(a1_ursprungstxt, COALESCE(a1_ursprungstxt_adktxt_rtf, belarzu__zu_tit__gettxt('EXPORT-URSPRUNG')), NULL)::TEXT
                                                                    AS dokument_exportursprungtxt,
       belarzu__zu_tit__gettxt('DOKU_EMAILTXT', ReportLang_current(), false)
                                                                    AS dokument_emailtxt, --prodat_languages.customerlang(beld_krzbesteller)
       
       
       ((SELECT count(1) FROM (SELECT DISTINCT COALESCE(ag_nr,''), COALESCE(belp_referenz,''), COALESCE(belp_projektnummer,'') FROM lieferschein_pos LEFT JOIN auftg ON ag_id=belp_ag_id WHERE beld_id=belp_dokument_id) AS a))
                                                                    AS dokument_positiongroupcount, --eine gleiche referenz über alles?

       beld_apkrzl                                                  AS dokument_adresse_ansprechpartner_adressant_ident,
       beld_ap                                                      AS dokument_adresse_ansprechpartner_adressant,
       ap_anr                                                       AS dokument_adresse_ansprechpartner_adressant_anr,
       ap_sex_man::VARCHAR(1)                                       AS dokument_adresse_ansprechpartner_adressant_man,
       ap_name                                                      AS dokument_adresse_ansprechpartner_adressant_nachname,
       ap_vorn                                                      AS dokument_adresse_ansprechpartner_adressant_vorname,
       ap_sysfun                                                    AS dokument_adresse_ansprechpartner_adressant_sysfun,
       ap_titel                                                     AS dokument_adresse_ansprechpartner_adressant_titel,
       
       beld_krzlieferung                                            AS dokument_adresse_adressant,
       adk_ad_krz                                                   AS dokument_adresse_ident, --zB dbrid für Parameter       
       
       ad_ustidnr                                                   AS ustidnr,
       
       NULL::FLOAT                                                  AS dokument_summe_netto,
       NULL::FLOAT                                                  AS dokument_summe_brutto,

       NULL::FLOAT                                                  AS dokument_fixwert,
       NULL::FLOAT                                                  AS dokument_gesamtrabatt,
       NULL::FLOAT                                                  AS dokument_gesamtrabatt_wert,
       
       NULL::CHAR(1)                                                AS dokument_bindefrist,
       
       beld_apint                                                   AS dokument_adresse_ap_intern_ident,
       nameAufloesen(beld_apint)                                    AS dokument_adresse_ap_intern_name,
       NULL::CHAR(1)                                                AS dokument_adresse_ap_intern_ident2,
       NULL::CHAR(1)                                                AS dokument_adresse_ap_intern_name2,
       
       COALESCE(ap_mail, ad_email1)                                 AS adresse_adressant_email,
       
       a1_knr::VARCHAR(50)                                          AS dokument_adresse_knr_debi_or_kredi, 
       a1_eknr::VARCHAR(50)                                         AS dokument_adresse_adressant_knr_debi_or_kredi,
       NULL::CHAR(1)                                                AS zahlung_waco,
       a1_spco                                                      AS sprache_debi_or_kredi, 
       a1_tolfrueh                                                  AS lieftolfrueh_debi_or_kredi,
       a1_tolspaet                                                  AS lieftolspaet_debi_or_kredi,
       a1_euexport                                                  AS euexport,
       a1_export                                                    AS intexport,
       IFTHEN(a1_euexport OR a1_export, a1_zaz, NULL::VARCHAR)      AS zazexport,   --ZAZ Nummer nur zeigen wenn Export
       IFTHEN(a1_euexport OR a1_export, ad_eori, NULL::VARCHAR)     AS eori_vertragspartner,    --EORI des Kunden
       
       NULL::INTEGER                                                AS zahlung_tage_zahlungbis,
       NULL::FLOAT                                                  AS zahlung_tage_skontoverfall,
       NULL::FLOAT                                                  AS zahlung_skontosatz_prozent,
       
       lang_za(a1_zahlart,ReportLang_current())                     AS zahlung_zahlart_name_debikredidat,
       NULL::CHAR(1)                                                AS zahlung_zahlkondition_bemerkung,

       kto_bknr,
       kto_blz,
       kto_bank,
       kto_bic,
       kto_iban,
       kto_pckonto,
       kto_bb,
          
       (SELECT s_bb FROM adkspco WHERE a1_spco = s_spco)            AS s_bb, --Hintergrund-Einstellung aus Sprache NEU
       
       beld_versandart                                              AS versand_versandart_ident, 
       COALESCE(lang_versart(v_id, ReportLang_current() ), beld_versandartbem)
                                                                    AS versand_versandart, -- neu #7137, war COALESCE(v_descr, beld_versandartbem)
       beld_versandort                                              AS versand_versandort,-- Ort des Gefahrenübergangs
       NULL::CHAR(1)                                                AS versand_bem,
       (SELECT (TAdk.DokVersandTyp(ad_dokversand)).ad_DokVersandBez FROM adk WHERE adk.ad_krz=adk_ad_krz) 
                                                                    AS dokument_versand, -- Dokumenten-Versandbezeichnung Adressstammdaten
       
       1                                                            AS preiseinheit_max,
       (SELECT MAX(LENGTH(ag_hwpos)) FROM lieferschein_pos LEFT JOIN auftg ON ag_id=belp_ag_id WHERE beld_id=belp_dokument_id LIMIT 1) 
                                                                    AS hwpos_max, --Strukturposition
       (SELECT MAX(LENGTH(ag_bdapos)) FROM lieferschein_pos LEFT JOIN auftg ON ag_id=belp_ag_id WHERE beld_id=belp_dokument_id LIMIT 1) 
                                                                    AS bdapos_max,   --Länge der Positionsnummerkunde 12607                                                         
       (SELECT MAX(numeric_larger(LENGTH(ABS(belp_menge-trunc(belp_menge))::FLOAT::VARCHAR)-2,0)) FROM lieferschein_pos WHERE beld_id=belp_dokument_id)  --Float cast wirft nachfolgende 0en weg  http://postgresql.1045698.n5.nabble.com/strip-zeros-from-fractional-part-td1849963.html
                                                                    AS dokument_menge_numdigits,
       0                                                            AS dokument_vkp_numdigits,
       0                                                            AS dokument_arab_numdigits
     FROM
       lieferschein                 JOIN (SELECT true) AS isLFS ON beld_belegtyp = 'LFS'-- LG Einschränkung auf Lieferschein, da where Statement nicht möglich
                                    LEFT JOIN adressen_view ON ad_krz=beld_krzrechnung --wegen Debitorendaten
                                    LEFT JOIN adk1 ON a1_krz=adk_ad_krz --debitorendaten zur Adresse
                                    LEFT JOIN ktovz ON kto_name=a1_ktv_name OR (a1_ktv_name IS NULL AND kto_std)
                                    LEFT JOIN adkap ON adk_ad_krz=ap_ad_krz AND ap_krzl=beld_apkrzl AND ap_krzl IS NOT NULL 
                                    LEFT JOIN versart ON v_art ILIKE beld_versandartbem; --LIKE-JOIN http://redmine.prodat-sql.de/issues/4981#note-6

    DROP VIEW IF EXISTS treporting.lieferschein_pos_abzuschlaege_pos;
    CREATE OR REPLACE VIEW treporting.lieferschein_pos_abzuschlaege_pos AS
     SELECT
      NULL::CHAR(1)                                                 AS position_id,
      NULL::CHAR(1)                                                 AS bezeichnung, -- prodat_languages.customerlang(belp_krzlieferung)
      NULL::CHAR(1)                                                 AS typ, --                       #7938 PHKO
      NULL::INTEGER                                                 AS pos, --                       #7938 PHKO
      NULL::NUMERIC(1,1)                                            AS anzahl,
      NULL::NUMERIC(1,1)                                            AS preis,
      NULL::NUMERIC(1,1)                                            AS preis_wert_netto,
      NULL::NUMERIC(1,1)                                            AS prozent,
      NULL::INTEGER                                                 AS steuercode,
      NULL::NUMERIC(1,1)                                            AS steuerprozent,
      false                                                         AS sichtbar,
      NULL::TEXT                                                    AS bemerkung, --                 #7938 PHKO
      NULL::TEXT                                                    AS bemerkung_intern, --          #7938 PHKO
      NULL::INTEGER                                                 AS abzu_menge_numdigits,
      NULL::INTEGER                                                 AS abzu_preis_numdigits
      ;
      

    DROP VIEW IF EXISTS treporting.lieferschein_abzuschlaege_beleg;
    CREATE OR REPLACE VIEW treporting.lieferschein_abzuschlaege_beleg AS
     SELECT
      NULL::CHAR(1)                                                 AS dokument_id,
      NULL::CHAR(1)                                                 AS bezeichnung,
      NULL::CHAR(1)                                                 AS typ, --                       #7938 PHKO
      NULL::INTEGER                                                 AS pos, --                       #7938 PHKO
      NULL::NUMERIC(1,1)                                            AS anzahl,
      NULL::NUMERIC(1,1)                                            AS preis,
      NULL::NUMERIC(1,1)                                            AS preis_wert_netto,
      NULL::NUMERIC(1,1)                                            AS prozent,
      NULL::INTEGER                                                 AS steuercode,
      NULL::NUMERIC(1,1)                                            AS steuerprozent,
      false                                                         AS sichtbar,
      NULL::TEXT                                                    AS bemerkung ,--                 #7938 PHKO #9255 GEO
      NULL::TEXT                                                    AS bemerkung_intern --           #7938 PHKO
     ;
      
     DROP VIEW IF EXISTS treporting.lieferschein_steuerartenbetrag;
     CREATE OR REPLACE VIEW treporting.lieferschein_steuerartenbetrag AS
     SELECT
      0                                                             AS dokument_id,
      -1                                                            AS steucode,
      0                                                             AS steuproz,
      0                                                             AS steubetrag,
      NULL::CHAR(1)                                                 AS steubez
     ;

END $$ LANGUAGE plpgsql;

--SELECT TSystem.views__ReportingLieferschein__recreate();
